@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyFontFamilyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fontFamily Font family name.
 */
public data class ThemeConfigurationTypographyFontFamilyArgs(
    public val fontFamily: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyFontFamilyArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyFontFamilyArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyFontFamilyArgs.builder()
            .fontFamily(fontFamily?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemeConfigurationTypographyFontFamilyArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationTypographyFontFamilyArgsBuilder internal constructor() {
    private var fontFamily: Output<String>? = null

    /**
     * @param value Font family name.
     */
    @JvmName("vqvyourhcwfuwiah")
    public suspend fun fontFamily(`value`: Output<String>) {
        this.fontFamily = value
    }

    /**
     * @param value Font family name.
     */
    @JvmName("hcxrrajovknlylhp")
    public suspend fun fontFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontFamily = mapped
    }

    internal fun build(): ThemeConfigurationTypographyFontFamilyArgs =
        ThemeConfigurationTypographyFontFamilyArgs(
            fontFamily = fontFamily,
        )
}
