@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationUiColorPaletteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accent Color (hexadecimal) that applies to selected states and buttons.
 * @property accentForeground Color (hexadecimal) that applies to any text or other elements that appear over the accent color.
 * @property danger Color (hexadecimal) that applies to error messages.
 * @property dangerForeground Color (hexadecimal) that applies to any text or other elements that appear over the error color.
 * @property dimension Color (hexadecimal) that applies to the names of fields that are identified as dimensions.
 * @property dimensionForeground Color (hexadecimal) that applies to any text or other elements that appear over the dimension color.
 * @property measure Color (hexadecimal) that applies to the names of fields that are identified as measures.
 * @property measureForeground Color (hexadecimal) that applies to any text or other elements that appear over the measure color.
 * @property primaryBackground Color (hexadecimal) that applies to visuals and other high emphasis UI.
 * @property primaryForeground Color (hexadecimal) of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
 * @property secondaryBackground Color (hexadecimal) that applies to the sheet background and sheet controls.
 * @property secondaryForeground Color (hexadecimal) that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
 * @property success Color (hexadecimal) that applies to success messages, for example the check mark for a successful download.
 * @property successForeground Color (hexadecimal) that applies to any text or other elements that appear over the success color.
 * @property warning Color (hexadecimal) that applies to warning and informational messages.
 * @property warningForeground Color (hexadecimal) that applies to any text or other elements that appear over the warning color.
 */
public data class ThemeConfigurationUiColorPaletteArgs(
    public val accent: Output<String>? = null,
    public val accentForeground: Output<String>? = null,
    public val danger: Output<String>? = null,
    public val dangerForeground: Output<String>? = null,
    public val dimension: Output<String>? = null,
    public val dimensionForeground: Output<String>? = null,
    public val measure: Output<String>? = null,
    public val measureForeground: Output<String>? = null,
    public val primaryBackground: Output<String>? = null,
    public val primaryForeground: Output<String>? = null,
    public val secondaryBackground: Output<String>? = null,
    public val secondaryForeground: Output<String>? = null,
    public val success: Output<String>? = null,
    public val successForeground: Output<String>? = null,
    public val warning: Output<String>? = null,
    public val warningForeground: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationUiColorPaletteArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationUiColorPaletteArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationUiColorPaletteArgs.builder()
            .accent(accent?.applyValue({ args0 -> args0 }))
            .accentForeground(accentForeground?.applyValue({ args0 -> args0 }))
            .danger(danger?.applyValue({ args0 -> args0 }))
            .dangerForeground(dangerForeground?.applyValue({ args0 -> args0 }))
            .dimension(dimension?.applyValue({ args0 -> args0 }))
            .dimensionForeground(dimensionForeground?.applyValue({ args0 -> args0 }))
            .measure(measure?.applyValue({ args0 -> args0 }))
            .measureForeground(measureForeground?.applyValue({ args0 -> args0 }))
            .primaryBackground(primaryBackground?.applyValue({ args0 -> args0 }))
            .primaryForeground(primaryForeground?.applyValue({ args0 -> args0 }))
            .secondaryBackground(secondaryBackground?.applyValue({ args0 -> args0 }))
            .secondaryForeground(secondaryForeground?.applyValue({ args0 -> args0 }))
            .success(success?.applyValue({ args0 -> args0 }))
            .successForeground(successForeground?.applyValue({ args0 -> args0 }))
            .warning(warning?.applyValue({ args0 -> args0 }))
            .warningForeground(warningForeground?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemeConfigurationUiColorPaletteArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationUiColorPaletteArgsBuilder internal constructor() {
    private var accent: Output<String>? = null

    private var accentForeground: Output<String>? = null

    private var danger: Output<String>? = null

    private var dangerForeground: Output<String>? = null

    private var dimension: Output<String>? = null

    private var dimensionForeground: Output<String>? = null

    private var measure: Output<String>? = null

    private var measureForeground: Output<String>? = null

    private var primaryBackground: Output<String>? = null

    private var primaryForeground: Output<String>? = null

    private var secondaryBackground: Output<String>? = null

    private var secondaryForeground: Output<String>? = null

    private var success: Output<String>? = null

    private var successForeground: Output<String>? = null

    private var warning: Output<String>? = null

    private var warningForeground: Output<String>? = null

    /**
     * @param value Color (hexadecimal) that applies to selected states and buttons.
     */
    @JvmName("robmktpgfucrixvd")
    public suspend fun accent(`value`: Output<String>) {
        this.accent = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the accent color.
     */
    @JvmName("ffhplqhqxxygdnvd")
    public suspend fun accentForeground(`value`: Output<String>) {
        this.accentForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to error messages.
     */
    @JvmName("unpuqynquiiyjqva")
    public suspend fun danger(`value`: Output<String>) {
        this.danger = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the error color.
     */
    @JvmName("buenraneekbjpmrr")
    public suspend fun dangerForeground(`value`: Output<String>) {
        this.dangerForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to the names of fields that are identified as dimensions.
     */
    @JvmName("wgeerronvmhnnssk")
    public suspend fun dimension(`value`: Output<String>) {
        this.dimension = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the dimension color.
     */
    @JvmName("vjmmsamspoqsoiop")
    public suspend fun dimensionForeground(`value`: Output<String>) {
        this.dimensionForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to the names of fields that are identified as measures.
     */
    @JvmName("vteyegkkewddiyjf")
    public suspend fun measure(`value`: Output<String>) {
        this.measure = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the measure color.
     */
    @JvmName("vuqsyxrbefmussuv")
    public suspend fun measureForeground(`value`: Output<String>) {
        this.measureForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to visuals and other high emphasis UI.
     */
    @JvmName("hmahsoepkqihgsev")
    public suspend fun primaryBackground(`value`: Output<String>) {
        this.primaryBackground = value
    }

    /**
     * @param value Color (hexadecimal) of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
     */
    @JvmName("kvvjbajfnlvtaafe")
    public suspend fun primaryForeground(`value`: Output<String>) {
        this.primaryForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to the sheet background and sheet controls.
     */
    @JvmName("dpygexppwaisfotu")
    public suspend fun secondaryBackground(`value`: Output<String>) {
        this.secondaryBackground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
     */
    @JvmName("iyddwtnmiqlpnjtd")
    public suspend fun secondaryForeground(`value`: Output<String>) {
        this.secondaryForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to success messages, for example the check mark for a successful download.
     */
    @JvmName("qvrojuuwwurrjlsv")
    public suspend fun success(`value`: Output<String>) {
        this.success = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the success color.
     */
    @JvmName("uytsgpjjngtjxpik")
    public suspend fun successForeground(`value`: Output<String>) {
        this.successForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to warning and informational messages.
     */
    @JvmName("tbfvxlqtwrtvgqgg")
    public suspend fun warning(`value`: Output<String>) {
        this.warning = value
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the warning color.
     */
    @JvmName("oejsmedlxvprjtim")
    public suspend fun warningForeground(`value`: Output<String>) {
        this.warningForeground = value
    }

    /**
     * @param value Color (hexadecimal) that applies to selected states and buttons.
     */
    @JvmName("kwgfaroqunkviqae")
    public suspend fun accent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accent = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the accent color.
     */
    @JvmName("aecgyggifbsgrita")
    public suspend fun accentForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accentForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to error messages.
     */
    @JvmName("wqrqicbtknypwetb")
    public suspend fun danger(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.danger = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the error color.
     */
    @JvmName("bsrvgoyjvrpcbpow")
    public suspend fun dangerForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dangerForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to the names of fields that are identified as dimensions.
     */
    @JvmName("frjobftmjrmqcqyf")
    public suspend fun dimension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the dimension color.
     */
    @JvmName("bhwdjwsriejavqcr")
    public suspend fun dimensionForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to the names of fields that are identified as measures.
     */
    @JvmName("cmossxkdnorbqhdb")
    public suspend fun measure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.measure = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the measure color.
     */
    @JvmName("uttxxbufpaqeqamt")
    public suspend fun measureForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.measureForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to visuals and other high emphasis UI.
     */
    @JvmName("owdreyrhbqroklrf")
    public suspend fun primaryBackground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryBackground = mapped
    }

    /**
     * @param value Color (hexadecimal) of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
     */
    @JvmName("elkofhfygnlanyju")
    public suspend fun primaryForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to the sheet background and sheet controls.
     */
    @JvmName("jkvfethaowumfmvg")
    public suspend fun secondaryBackground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryBackground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
     */
    @JvmName("aemsyxvacefbkdsc")
    public suspend fun secondaryForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to success messages, for example the check mark for a successful download.
     */
    @JvmName("vmwnfkyyuculrgue")
    public suspend fun success(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.success = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the success color.
     */
    @JvmName("pvekjbihrxjbhbcx")
    public suspend fun successForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successForeground = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to warning and informational messages.
     */
    @JvmName("xdpytjkenpkyweqq")
    public suspend fun warning(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warning = mapped
    }

    /**
     * @param value Color (hexadecimal) that applies to any text or other elements that appear over the warning color.
     */
    @JvmName("effumwafxinyqeab")
    public suspend fun warningForeground(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warningForeground = mapped
    }

    internal fun build(): ThemeConfigurationUiColorPaletteArgs = ThemeConfigurationUiColorPaletteArgs(
        accent = accent,
        accentForeground = accentForeground,
        danger = danger,
        dangerForeground = dangerForeground,
        dimension = dimension,
        dimensionForeground = dimensionForeground,
        measure = measure,
        measureForeground = measureForeground,
        primaryBackground = primaryBackground,
        primaryForeground = primaryForeground,
        secondaryBackground = secondaryBackground,
        secondaryForeground = secondaryForeground,
        success = success,
        successForeground = successForeground,
        warning = warning,
        warningForeground = warningForeground,
    )
}
