@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemePermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions List of IAM actions to grant or revoke permissions on.
 * @property principal ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
 */
public data class ThemePermissionArgs(
    public val actions: Output<List<String>>,
    public val principal: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemePermissionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemePermissionArgs =
        com.pulumi.aws.quicksight.inputs.ThemePermissionArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principal(principal.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemePermissionArgs].
 */
@PulumiTagMarker
public class ThemePermissionArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var principal: Output<String>? = null

    /**
     * @param value List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("wteqnuawemwaokjt")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("rhdieornuswjikdn")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("blqumrfegklruswu")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
     */
    @JvmName("kpipkrytmatxukua")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("joyhbgbwliulgpjd")
    public suspend fun actions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("uovowjdwaxitcqmh")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
     */
    @JvmName("ipdxgdcugvtyclfb")
    public suspend fun principal(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): ThemePermissionArgs = ThemePermissionArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        principal = principal ?: throw PulumiNullFieldException("principal"),
    )
}
