@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 * @property dataSetReferences List of dataset references. See data_set_references.
 */
public data class AnalysisSourceEntitySourceTemplate(
    public val arn: String,
    public val dataSetReferences: List<AnalysisSourceEntitySourceTemplateDataSetReference>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.AnalysisSourceEntitySourceTemplate):
            AnalysisSourceEntitySourceTemplate = AnalysisSourceEntitySourceTemplate(
            arn = javaType.arn(),
            dataSetReferences = javaType.dataSetReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.AnalysisSourceEntitySourceTemplateDataSetReference.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
