@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property adHocFilteringOption Ad hoc (one-time) filtering option. See ad_hoc_filtering_option.
 * @property dataPointDrillUpDownOption The drill-down options of data points in a dashboard. See data_point_drill_up_down_option.
 * @property dataPointMenuLabelOption The data point menu label options of a dashboard. See data_point_menu_label_option.
 * @property dataPointTooltipOption The data point tool tip options of a dashboard. See data_point_tooltip_option.
 * @property exportToCsvOption Export to .csv option. See export_to_csv_option.
 * @property exportWithHiddenFieldsOption Determines if hidden fields are exported with a dashboard. See export_with_hidden_fields_option.
 * @property sheetControlsOption Sheet controls option. See sheet_controls_option.
 * @property sheetLayoutElementMaximizationOption The sheet layout maximization options of a dashboard. See sheet_layout_element_maximization_option.
 * @property visualAxisSortOption The axis sort options of a dashboard. See visual_axis_sort_option.
 * @property visualMenuOption The menu options of a visual in a dashboard. See visual_menu_option.
 */
public data class DashboardDashboardPublishOptions(
    public val adHocFilteringOption: DashboardDashboardPublishOptionsAdHocFilteringOption? = null,
    public val dataPointDrillUpDownOption: DashboardDashboardPublishOptionsDataPointDrillUpDownOption? =
        null,
    public val dataPointMenuLabelOption: DashboardDashboardPublishOptionsDataPointMenuLabelOption? =
        null,
    public val dataPointTooltipOption: DashboardDashboardPublishOptionsDataPointTooltipOption? = null,
    public val exportToCsvOption: DashboardDashboardPublishOptionsExportToCsvOption? = null,
    public val exportWithHiddenFieldsOption:
    DashboardDashboardPublishOptionsExportWithHiddenFieldsOption? = null,
    public val sheetControlsOption: DashboardDashboardPublishOptionsSheetControlsOption? = null,
    public val sheetLayoutElementMaximizationOption:
    DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOption? = null,
    public val visualAxisSortOption: DashboardDashboardPublishOptionsVisualAxisSortOption? = null,
    public val visualMenuOption: DashboardDashboardPublishOptionsVisualMenuOption? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DashboardDashboardPublishOptions):
            DashboardDashboardPublishOptions = DashboardDashboardPublishOptions(
            adHocFilteringOption = javaType.adHocFilteringOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsAdHocFilteringOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataPointDrillUpDownOption = javaType.dataPointDrillUpDownOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsDataPointDrillUpDownOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataPointMenuLabelOption = javaType.dataPointMenuLabelOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsDataPointMenuLabelOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataPointTooltipOption = javaType.dataPointTooltipOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsDataPointTooltipOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exportToCsvOption = javaType.exportToCsvOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsExportToCsvOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exportWithHiddenFieldsOption = javaType.exportWithHiddenFieldsOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsExportWithHiddenFieldsOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sheetControlsOption = javaType.sheetControlsOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsSheetControlsOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sheetLayoutElementMaximizationOption = javaType.sheetLayoutElementMaximizationOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            visualAxisSortOption = javaType.visualAxisSortOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsVisualAxisSortOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            visualMenuOption = javaType.visualMenuOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptionsVisualMenuOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
