@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columns Columns in this hierarchy.
 * @property countryCode Country code. Valid values are `US`.
 * @property name A display name for the hierarchy.
 */
public data class DataSetColumnGroupGeoSpatialColumnGroup(
    public val columns: List<String>,
    public val countryCode: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetColumnGroupGeoSpatialColumnGroup):
            DataSetColumnGroupGeoSpatialColumnGroup = DataSetColumnGroupGeoSpatialColumnGroup(
            columns = javaType.columns().map({ args0 -> args0 }),
            countryCode = javaType.countryCode(),
            name = javaType.name(),
        )
    }
}
