@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property disableUseAsDirectQuerySource Controls whether a child dataset of a direct query can use this dataset as a source.
 * @property disableUseAsImportedSource Controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
 */
public data class DataSetDataSetUsageConfiguration(
    public val disableUseAsDirectQuerySource: Boolean? = null,
    public val disableUseAsImportedSource: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetDataSetUsageConfiguration):
            DataSetDataSetUsageConfiguration = DataSetDataSetUsageConfiguration(
            disableUseAsDirectQuerySource = javaType.disableUseAsDirectQuerySource().map({ args0 ->
                args0
            }).orElse(null),
            disableUseAsImportedSource = javaType.disableUseAsImportedSource().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
