@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columns An array of column names to add to the folder. A column can only be in one folder.
 * @property description Field folder description.
 * @property fieldFoldersId Key of the field folder map.
 */
public data class DataSetFieldFolder(
    public val columns: List<String>? = null,
    public val description: String? = null,
    public val fieldFoldersId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetFieldFolder):
            DataSetFieldFolder = DataSetFieldFolder(
            columns = javaType.columns().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fieldFoldersId = javaType.fieldFoldersId(),
        )
    }
}
