@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property castColumnTypeOperation A transform operation that casts a column to a different type. See cast_column_type_operation.
 * @property createColumnsOperation An operation that creates calculated columns. Columns created in one such operation form a lexical closure. See create_columns_operation.
 * @property filterOperation An operation that filters rows based on some condition. See filter_operation.
 * @property projectOperation An operation that projects columns. Operations that come after a projection can only refer to projected columns. See project_operation.
 * @property renameColumnOperation An operation that renames a column. See rename_column_operation.
 * @property tagColumnOperation An operation that tags a column with additional information. See tag_column_operation.
 * @property untagColumnOperation A transform operation that removes tags associated with a column. See untag_column_operation.
 */
public data class DataSetLogicalTableMapDataTransform(
    public val castColumnTypeOperation: DataSetLogicalTableMapDataTransformCastColumnTypeOperation? =
        null,
    public val createColumnsOperation: DataSetLogicalTableMapDataTransformCreateColumnsOperation? =
        null,
    public val filterOperation: DataSetLogicalTableMapDataTransformFilterOperation? = null,
    public val projectOperation: DataSetLogicalTableMapDataTransformProjectOperation? = null,
    public val renameColumnOperation: DataSetLogicalTableMapDataTransformRenameColumnOperation? =
        null,
    public val tagColumnOperation: DataSetLogicalTableMapDataTransformTagColumnOperation? = null,
    public val untagColumnOperation: DataSetLogicalTableMapDataTransformUntagColumnOperation? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapDataTransform):
            DataSetLogicalTableMapDataTransform = DataSetLogicalTableMapDataTransform(
            castColumnTypeOperation = javaType.castColumnTypeOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createColumnsOperation = javaType.createColumnsOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformCreateColumnsOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filterOperation = javaType.filterOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformFilterOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            projectOperation = javaType.projectOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformProjectOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            renameColumnOperation = javaType.renameColumnOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformRenameColumnOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tagColumnOperation = javaType.tagColumnOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformTagColumnOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            untagColumnOperation = javaType.untagColumnOperation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformUntagColumnOperation.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
