@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property columnName Column name.
 * @property format When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
 * @property newColumnType New column data type. Valid values are `STRING`, `INTEGER`, `DECIMAL`, `DATETIME`.
 */
public data class DataSetLogicalTableMapDataTransformCastColumnTypeOperation(
    public val columnName: String,
    public val format: String? = null,
    public val newColumnType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperation):
            DataSetLogicalTableMapDataTransformCastColumnTypeOperation =
            DataSetLogicalTableMapDataTransformCastColumnTypeOperation(
                columnName = javaType.columnName(),
                format = javaType.format().map({ args0 -> args0 }).orElse(null),
                newColumnType = javaType.newColumnType(),
            )
    }
}
