@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property columnId A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
 * @property columnName Column name.
 * @property expression An expression that defines the calculated column.
 */
public data class DataSetLogicalTableMapDataTransformCreateColumnsOperationColumn(
    public val columnId: String,
    public val columnName: String,
    public val expression: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationColumn):
            DataSetLogicalTableMapDataTransformCreateColumnsOperationColumn =
            DataSetLogicalTableMapDataTransformCreateColumnsOperationColumn(
                columnId = javaType.columnId(),
                columnName = javaType.columnName(),
                expression = javaType.expression(),
            )
    }
}
