@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columnName Column name.
 * @property tags The dataset column tag, currently only used for geospatial type tagging. See tags.
 */
public data class DataSetLogicalTableMapDataTransformTagColumnOperation(
    public val columnName: String,
    public val tags: List<DataSetLogicalTableMapDataTransformTagColumnOperationTag>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapDataTransformTagColumnOperation):
            DataSetLogicalTableMapDataTransformTagColumnOperation =
            DataSetLogicalTableMapDataTransformTagColumnOperation(
                columnName = javaType.columnName(),
                tags = javaType.tags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransformTagColumnOperationTag.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
