@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataSetArn ARN of the parent data set.
 * @property joinInstruction Specifies the result of a join of two logical tables. See join_instruction.
 * @property physicalTableId Physical table ID.
 */
public data class DataSetLogicalTableMapSource(
    public val dataSetArn: String? = null,
    public val joinInstruction: DataSetLogicalTableMapSourceJoinInstruction? = null,
    public val physicalTableId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapSource):
            DataSetLogicalTableMapSource = DataSetLogicalTableMapSource(
            dataSetArn = javaType.dataSetArn().map({ args0 -> args0 }).orElse(null),
            joinInstruction = javaType.joinInstruction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapSourceJoinInstruction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            physicalTableId = javaType.physicalTableId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
