@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customSql A physical table type built from the results of the custom SQL query. See custom_sql.
 * @property physicalTableMapId Key of the physical table map.
 * @property relationalTable A physical table type for relational data sources. See relational_table.
 * @property s3Source A physical table type for as S3 data source. See s3_source.
 */
public data class DataSetPhysicalTableMap(
    public val customSql: DataSetPhysicalTableMapCustomSql? = null,
    public val physicalTableMapId: String,
    public val relationalTable: DataSetPhysicalTableMapRelationalTable? = null,
    public val s3Source: DataSetPhysicalTableMapS3Source? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPhysicalTableMap):
            DataSetPhysicalTableMap = DataSetPhysicalTableMap(
            customSql = javaType.customSql().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapCustomSql.Companion.toKotlin(args0)
                })
            }).orElse(null),
            physicalTableMapId = javaType.physicalTableMapId(),
            relationalTable = javaType.relationalTable().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapRelationalTable.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Source = javaType.s3Source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapS3Source.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
