@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataSourceArn ARN of the data source.
 * @property inputColumns Column schema of the table. See input_columns.
 * @property uploadSettings Information about the format for the S3 source file or files. See upload_settings.
 */
public data class DataSetPhysicalTableMapS3Source(
    public val dataSourceArn: String,
    public val inputColumns: List<DataSetPhysicalTableMapS3SourceInputColumn>,
    public val uploadSettings: DataSetPhysicalTableMapS3SourceUploadSettings,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPhysicalTableMapS3Source):
            DataSetPhysicalTableMapS3Source = DataSetPhysicalTableMapS3Source(
            dataSourceArn = javaType.dataSourceArn(),
            inputColumns = javaType.inputColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapS3SourceInputColumn.Companion.toKotlin(args0)
                })
            }),
            uploadSettings = javaType.uploadSettings().let({ args0 ->
                com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapS3SourceUploadSettings.Companion.toKotlin(args0)
            }),
        )
    }
}
