@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containsHeader Whether the file has a header row, or the files each have a header row.
 * @property delimiter Delimiter between values in the file.
 * @property format File format. Valid values are `CSV`, `TSV`, `CLF`, `ELF`, `XLSX`, and `JSON`.
 * @property startFromRow A row number to start reading data from.
 * @property textQualifier Text qualifier. Valid values are `DOUBLE_QUOTE` and `SINGLE_QUOTE`.
 */
public data class DataSetPhysicalTableMapS3SourceUploadSettings(
    public val containsHeader: Boolean? = null,
    public val delimiter: String? = null,
    public val format: String? = null,
    public val startFromRow: Int? = null,
    public val textQualifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPhysicalTableMapS3SourceUploadSettings):
            DataSetPhysicalTableMapS3SourceUploadSettings =
            DataSetPhysicalTableMapS3SourceUploadSettings(
                containsHeader = javaType.containsHeader().map({ args0 -> args0 }).orElse(null),
                delimiter = javaType.delimiter().map({ args0 -> args0 }).orElse(null),
                format = javaType.format().map({ args0 -> args0 }).orElse(null),
                startFromRow = javaType.startFromRow().map({ args0 -> args0 }).orElse(null),
                textQualifier = javaType.textQualifier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
