@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the dataset that contains permissions for RLS.
 * @property formatVersion User or group rules associated with the dataset that contains permissions for RLS.
 * @property namespace Namespace associated with the dataset that contains permissions for RLS.
 * @property permissionPolicy Type of permissions to use when interpreting the permissions for RLS. Valid values are `GRANT_ACCESS` and `DENY_ACCESS`.
 * @property status Status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
 */
public data class DataSetRowLevelPermissionDataSet(
    public val arn: String,
    public val formatVersion: String? = null,
    public val namespace: String? = null,
    public val permissionPolicy: String,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetRowLevelPermissionDataSet):
            DataSetRowLevelPermissionDataSet = DataSetRowLevelPermissionDataSet(
            arn = javaType.arn(),
            formatVersion = javaType.formatVersion().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            permissionPolicy = javaType.permissionPolicy(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
