@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property status The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
 * @property tagRules A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
 */
public data class DataSetRowLevelPermissionTagConfiguration(
    public val status: String? = null,
    public val tagRules: List<DataSetRowLevelPermissionTagConfigurationTagRule>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetRowLevelPermissionTagConfiguration):
            DataSetRowLevelPermissionTagConfiguration = DataSetRowLevelPermissionTagConfiguration(
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tagRules = javaType.tagRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetRowLevelPermissionTagConfigurationTagRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
