@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the bucket that contains the manifest file.
 * @property key The key of the manifest file within the bucket.
 */
public data class DataSourceParametersS3ManifestFileLocation(
    public val bucket: String,
    public val key: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParametersS3ManifestFileLocation):
            DataSourceParametersS3ManifestFileLocation = DataSourceParametersS3ManifestFileLocation(
            bucket = javaType.bucket(),
            key = javaType.key(),
        )
    }
}
