@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property warehouse The warehouse to which to connect.
 */
public data class DataSourceParametersSnowflake(
    public val database: String,
    public val host: String,
    public val warehouse: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParametersSnowflake):
            DataSourceParametersSnowflake = DataSourceParametersSnowflake(
            database = javaType.database(),
            host = javaType.host(),
            warehouse = javaType.warehouse(),
        )
    }
}
