@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxRows The maximum number of rows to query.
 * @property query The Twitter query to retrieve the data.
 */
public data class DataSourceParametersTwitter(
    public val maxRows: Int,
    public val query: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParametersTwitter):
            DataSourceParametersTwitter = DataSourceParametersTwitter(
            maxRows = javaType.maxRows(),
            query = javaType.query(),
        )
    }
}
