@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions Set of IAM actions to grant or revoke permissions on. Max of 16 items.
 * @property principal The Amazon Resource Name (ARN) of the principal.
 */
public data class DataSourcePermission(
    public val actions: List<String>,
    public val principal: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourcePermission):
            DataSourcePermission = DataSourcePermission(
            actions = javaType.actions().map({ args0 -> args0 }),
            principal = javaType.principal(),
        )
    }
}
