@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDataSet.
 * @property arn
 * @property awsAccountId
 * @property columnGroups
 * @property columnLevelPermissionRules
 * @property dataSetId
 * @property dataSetUsageConfigurations
 * @property fieldFolders
 * @property id The provider-assigned unique ID for this managed resource.
 * @property importMode
 * @property logicalTableMaps
 * @property name
 * @property permissions
 * @property physicalTableMaps
 * @property rowLevelPermissionDataSets
 * @property rowLevelPermissionTagConfigurations
 * @property tags
 * @property tagsAll
 */
public data class GetDataSetResult(
    public val arn: String,
    public val awsAccountId: String,
    public val columnGroups: List<GetDataSetColumnGroup>,
    public val columnLevelPermissionRules: List<GetDataSetColumnLevelPermissionRule>? = null,
    public val dataSetId: String,
    public val dataSetUsageConfigurations: List<GetDataSetDataSetUsageConfiguration>,
    public val fieldFolders: List<GetDataSetFieldFolder>,
    public val id: String,
    public val importMode: String,
    public val logicalTableMaps: List<GetDataSetLogicalTableMap>,
    public val name: String,
    public val permissions: List<GetDataSetPermission>,
    public val physicalTableMaps: List<GetDataSetPhysicalTableMap>,
    public val rowLevelPermissionDataSets: List<GetDataSetRowLevelPermissionDataSet>,
    public val rowLevelPermissionTagConfigurations:
    List<GetDataSetRowLevelPermissionTagConfiguration>,
    public val tags: Map<String, String>,
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val tagsAll: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetDataSetResult):
            GetDataSetResult = GetDataSetResult(
            arn = javaType.arn(),
            awsAccountId = javaType.awsAccountId(),
            columnGroups = javaType.columnGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetColumnGroup.Companion.toKotlin(args0)
                })
            }),
            columnLevelPermissionRules = javaType.columnLevelPermissionRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetColumnLevelPermissionRule.Companion.toKotlin(args0)
                })
            }),
            dataSetId = javaType.dataSetId(),
            dataSetUsageConfigurations = javaType.dataSetUsageConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetDataSetUsageConfiguration.Companion.toKotlin(args0)
                })
            }),
            fieldFolders = javaType.fieldFolders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetFieldFolder.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            importMode = javaType.importMode(),
            logicalTableMaps = javaType.logicalTableMaps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetLogicalTableMap.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetPermission.Companion.toKotlin(args0)
                })
            }),
            physicalTableMaps = javaType.physicalTableMaps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetPhysicalTableMap.Companion.toKotlin(args0)
                })
            }),
            rowLevelPermissionDataSets = javaType.rowLevelPermissionDataSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetRowLevelPermissionDataSet.Companion.toKotlin(args0)
                })
            }),
            rowLevelPermissionTagConfigurations = javaType.rowLevelPermissionTagConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetRowLevelPermissionTagConfiguration.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tagsAll = javaType.tagsAll().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
