@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getQuicksightGroup.
 * @property arn The Amazon Resource Name (ARN) for the group.
 * @property awsAccountId
 * @property description The group description.
 * @property groupName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namespace
 * @property principalId The principal ID of the group.
 */
public data class GetQuicksightGroupResult(
    public val arn: String,
    public val awsAccountId: String,
    public val description: String,
    public val groupName: String,
    public val id: String,
    public val namespace: String? = null,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetQuicksightGroupResult):
            GetQuicksightGroupResult = GetQuicksightGroupResult(
            arn = javaType.arn(),
            awsAccountId = javaType.awsAccountId(),
            description = javaType.description(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId(),
        )
    }
}
