@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getQuicksightUser.
 * @property active The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.
 * @property arn The Amazon Resource Name (ARN) for the user.
 * @property awsAccountId
 * @property email The user's email address.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityType The type of identity authentication used by the user.
 * @property namespace
 * @property principalId The principal ID of the user.
 * @property userName
 * @property userRole The Amazon QuickSight role for the user. The user role can be one of the following:.
 */
public data class GetQuicksightUserResult(
    public val active: Boolean,
    public val arn: String,
    public val awsAccountId: String,
    public val email: String,
    public val id: String,
    public val identityType: String,
    public val namespace: String? = null,
    public val principalId: String,
    public val userName: String,
    public val userRole: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetQuicksightUserResult):
            GetQuicksightUserResult = GetQuicksightUserResult(
            active = javaType.active(),
            arn = javaType.arn(),
            awsAccountId = javaType.awsAccountId(),
            email = javaType.email(),
            id = javaType.id(),
            identityType = javaType.identityType(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId(),
            userName = javaType.userName(),
            userRole = javaType.userRole(),
        )
    }
}
