@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataColorPalettes Color properties that apply to chart data colors. See data_color_palette.
 * @property sheets Display options related to sheets. See sheet.
 * @property typographies Determines the typography options. See typography.
 * @property uiColorPalettes Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
 */
public data class GetThemeConfiguration(
    public val dataColorPalettes: List<GetThemeConfigurationDataColorPalette>,
    public val sheets: List<GetThemeConfigurationSheet>,
    public val typographies: List<GetThemeConfigurationTypography>,
    public val uiColorPalettes: List<GetThemeConfigurationUiColorPalette>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetThemeConfiguration):
            GetThemeConfiguration = GetThemeConfiguration(
            dataColorPalettes = javaType.dataColorPalettes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationDataColorPalette.Companion.toKotlin(args0)
                })
            }),
            sheets = javaType.sheets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationSheet.Companion.toKotlin(args0)
                })
            }),
            typographies = javaType.typographies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationTypography.Companion.toKotlin(args0)
                })
            }),
            uiColorPalettes = javaType.uiColorPalettes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationUiColorPalette.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
