@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property colors List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
 * @property emptyFillColor The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
 * @property minMaxGradients The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
 */
public data class GetThemeConfigurationDataColorPalette(
    public val colors: List<String>,
    public val emptyFillColor: String,
    public val minMaxGradients: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetThemeConfigurationDataColorPalette):
            GetThemeConfigurationDataColorPalette = GetThemeConfigurationDataColorPalette(
            colors = javaType.colors().map({ args0 -> args0 }),
            emptyFillColor = javaType.emptyFillColor(),
            minMaxGradients = javaType.minMaxGradients().map({ args0 -> args0 }),
        )
    }
}
