@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property gutters The gutter settings that apply between tiles. See gutter.
 * @property margins The margin settings that apply around the outside edge of sheets. See margin.
 */
public data class GetThemeConfigurationSheetTileLayout(
    public val gutters: List<GetThemeConfigurationSheetTileLayoutGutter>,
    public val margins: List<GetThemeConfigurationSheetTileLayoutMargin>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetThemeConfigurationSheetTileLayout):
            GetThemeConfigurationSheetTileLayout = GetThemeConfigurationSheetTileLayout(
            gutters = javaType.gutters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationSheetTileLayoutGutter.Companion.toKotlin(args0)
                })
            }),
            margins = javaType.margins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfigurationSheetTileLayoutMargin.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
