@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accent Color (hexadecimal) that applies to selected states and buttons.
 * @property accentForeground Color (hexadecimal) that applies to any text or other elements that appear over the accent color.
 * @property danger Color (hexadecimal) that applies to error messages.
 * @property dangerForeground Color (hexadecimal) that applies to any text or other elements that appear over the error color.
 * @property dimension Color (hexadecimal) that applies to the names of fields that are identified as dimensions.
 * @property dimensionForeground Color (hexadecimal) that applies to any text or other elements that appear over the dimension color.
 * @property measure Color (hexadecimal) that applies to the names of fields that are identified as measures.
 * @property measureForeground Color (hexadecimal) that applies to any text or other elements that appear over the measure color.
 * @property primaryBackground Color (hexadecimal) that applies to visuals and other high emphasis UI.
 * @property primaryForeground Color (hexadecimal) of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
 * @property secondaryBackground Color (hexadecimal) that applies to the sheet background and sheet controls.
 * @property secondaryForeground Color (hexadecimal) that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
 * @property success Color (hexadecimal) that applies to success messages, for example the check mark for a successful download.
 * @property successForeground Color (hexadecimal) that applies to any text or other elements that appear over the success color.
 * @property warning Color (hexadecimal) that applies to warning and informational messages.
 * @property warningForeground Color (hexadecimal) that applies to any text or other elements that appear over the warning color.
 */
public data class GetThemeConfigurationUiColorPalette(
    public val accent: String,
    public val accentForeground: String,
    public val danger: String,
    public val dangerForeground: String,
    public val dimension: String,
    public val dimensionForeground: String,
    public val measure: String,
    public val measureForeground: String,
    public val primaryBackground: String,
    public val primaryForeground: String,
    public val secondaryBackground: String,
    public val secondaryForeground: String,
    public val success: String,
    public val successForeground: String,
    public val warning: String,
    public val warningForeground: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetThemeConfigurationUiColorPalette):
            GetThemeConfigurationUiColorPalette = GetThemeConfigurationUiColorPalette(
            accent = javaType.accent(),
            accentForeground = javaType.accentForeground(),
            danger = javaType.danger(),
            dangerForeground = javaType.dangerForeground(),
            dimension = javaType.dimension(),
            dimensionForeground = javaType.dimensionForeground(),
            measure = javaType.measure(),
            measureForeground = javaType.measureForeground(),
            primaryBackground = javaType.primaryBackground(),
            primaryForeground = javaType.primaryForeground(),
            secondaryBackground = javaType.secondaryBackground(),
            secondaryForeground = javaType.secondaryForeground(),
            success = javaType.success(),
            successForeground = javaType.successForeground(),
            warning = javaType.warning(),
            warningForeground = javaType.warningForeground(),
        )
    }
}
