@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getTheme.
 * @property arn ARN of the theme.
 * @property awsAccountId
 * @property baseThemeId The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight.
 * @property configurations The theme configuration, which contains the theme display properties. See configuration.
 * @property createdTime The time that the theme was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedTime The time that the theme was last updated.
 * @property name Display name of the theme.
 * @property permissions A set of resource permissions on the theme. See permissions.
 * @property status The theme creation status.
 * @property tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 * @property themeId
 * @property versionDescription A description of the current theme version being created/updated.
 * @property versionNumber The version number of the theme version.
 */
public data class GetThemeResult(
    public val arn: String,
    public val awsAccountId: String,
    public val baseThemeId: String,
    public val configurations: List<GetThemeConfiguration>,
    public val createdTime: String,
    public val id: String,
    public val lastUpdatedTime: String,
    public val name: String,
    public val permissions: List<GetThemePermission>,
    public val status: String,
    public val tags: Map<String, String>,
    public val themeId: String,
    public val versionDescription: String,
    public val versionNumber: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetThemeResult): GetThemeResult =
            GetThemeResult(
                arn = javaType.arn(),
                awsAccountId = javaType.awsAccountId(),
                baseThemeId = javaType.baseThemeId(),
                configurations = javaType.configurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.quicksight.kotlin.outputs.GetThemeConfiguration.Companion.toKotlin(args0)
                    })
                }),
                createdTime = javaType.createdTime(),
                id = javaType.id(),
                lastUpdatedTime = javaType.lastUpdatedTime(),
                name = javaType.name(),
                permissions = javaType.permissions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.quicksight.kotlin.outputs.GetThemePermission.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                themeId = javaType.themeId(),
                versionDescription = javaType.versionDescription(),
                versionNumber = javaType.versionNumber(),
            )
    }
}
