@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property refreshType The type of refresh that the dataset undergoes. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
 * @property scheduleFrequency The configuration of the [schedule frequency](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshFrequency.html). See schedule_frequency.
 * @property startAfterDateTime Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
 */
public data class RefreshScheduleSchedule(
    public val refreshType: String,
    public val scheduleFrequency: RefreshScheduleScheduleScheduleFrequency? = null,
    public val startAfterDateTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.RefreshScheduleSchedule):
            RefreshScheduleSchedule = RefreshScheduleSchedule(
            refreshType = javaType.refreshType(),
            scheduleFrequency = javaType.scheduleFrequency().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleScheduleScheduleFrequency.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startAfterDateTime = javaType.startAfterDateTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
