@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property interval The interval between scheduled refreshes. Valid values are `MINUTE15`, `MINUTE30`, `HOURLY`, `DAILY`, `WEEKLY` and `MONTHLY`.
 * @property refreshOnDay The [refresh on entity](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ScheduleRefreshOnEntity.html) configuration for weekly or monthly schedules. See refresh_on_day.
 * @property timeOfTheDay The time of day that you want the dataset to refresh. This value is expressed in `HH:MM` format. This field is not required for schedules that refresh hourly.
 * @property timezone The timezone that you want the refresh schedule to use.
 */
public data class RefreshScheduleScheduleScheduleFrequency(
    public val interval: String,
    public val refreshOnDay: RefreshScheduleScheduleScheduleFrequencyRefreshOnDay? = null,
    public val timeOfTheDay: String? = null,
    public val timezone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.RefreshScheduleScheduleScheduleFrequency):
            RefreshScheduleScheduleScheduleFrequency = RefreshScheduleScheduleScheduleFrequency(
            interval = javaType.interval(),
            refreshOnDay = javaType.refreshOnDay().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDay.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeOfTheDay = javaType.timeOfTheDay().map({ args0 -> args0 }).orElse(null),
            timezone = javaType.timezone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
