@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property sourceAnalysis The source analysis, if it is based on an analysis.. Only one of `source_analysis` or `source_template` should be configured. See source_analysis.
 * @property sourceTemplate The source template, if it is based on an template.. Only one of `source_analysis` or `source_template` should be configured. See source_template.
 */
public data class TemplateSourceEntity(
    public val sourceAnalysis: TemplateSourceEntitySourceAnalysis? = null,
    public val sourceTemplate: TemplateSourceEntitySourceTemplate? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.TemplateSourceEntity):
            TemplateSourceEntity = TemplateSourceEntity(
            sourceAnalysis = javaType.sourceAnalysis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.TemplateSourceEntitySourceAnalysis.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceTemplate = javaType.sourceTemplate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.TemplateSourceEntitySourceTemplate.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
