@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourceAssociation].
 */
@PulumiTagMarker
public class ResourceAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceAssociationArgs = ResourceAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceAssociationArgsBuilder.() -> Unit) {
        val builder = ResourceAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourceAssociation {
        val builtJavaResource = com.pulumi.aws.ram.ResourceAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceAssociation(builtJavaResource)
    }
}

/**
 * Manages a Resource Access Manager (RAM) Resource Association.
 * > *NOTE:* Certain AWS resources (e.g., EC2 Subnets) can only be shared in an AWS account that is a member of an AWS Organizations organization with organization-wide Resource Access Manager functionality enabled. See the [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html) and AWS service specific documentation for additional information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceAssociation;
 * import com.pulumi.aws.ram.ResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceAssociation("example", ResourceAssociationArgs.builder()
 *             .resourceArn(aws_subnet.example().arn())
 *             .resourceShareArn(aws_ram_resource_share.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RAM Resource Associations using their Resource Share ARN and Resource ARN separated by a comma. For example:
 * ```sh
 *  $ pulumi import aws:ram/resourceAssociation:ResourceAssociation example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12,arn:aws:ec2:eu-west-1:123456789012:subnet/subnet-12345678
 * ```
 *
 */
public class ResourceAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ram.ResourceAssociation,
) : KotlinCustomResource(javaResource, ResourceAssociationMapper) {
    /**
     * Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the RAM Resource Share.
     */
    public val resourceShareArn: Output<String>
        get() = javaResource.resourceShareArn().applyValue({ args0 -> args0 })
}

public object ResourceAssociationMapper : ResourceMapper<ResourceAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ram.ResourceAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ResourceAssociation = ResourceAssociation(
        javaResource
            as com.pulumi.aws.ram.ResourceAssociation,
    )
}

/**
 * @see [ResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceAssociation].
 */
public suspend fun resourceAssociation(
    name: String,
    block: suspend ResourceAssociationResourceBuilder.() -> Unit,
): ResourceAssociation {
    val builder = ResourceAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceAssociation(name: String): ResourceAssociation {
    val builder = ResourceAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
