@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.aws.ram.ResourceAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Resource Access Manager (RAM) Resource Association.
 * > *NOTE:* Certain AWS resources (e.g., EC2 Subnets) can only be shared in an AWS account that is a member of an AWS Organizations organization with organization-wide Resource Access Manager functionality enabled. See the [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html) and AWS service specific documentation for additional information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceAssociation;
 * import com.pulumi.aws.ram.ResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceAssociation("example", ResourceAssociationArgs.builder()
 *             .resourceArn(aws_subnet.example().arn())
 *             .resourceShareArn(aws_ram_resource_share.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RAM Resource Associations using their Resource Share ARN and Resource ARN separated by a comma. For example:
 * ```sh
 *  $ pulumi import aws:ram/resourceAssociation:ResourceAssociation example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12,arn:aws:ec2:eu-west-1:123456789012:subnet/subnet-12345678
 * ```
 * @property resourceArn Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
 * @property resourceShareArn Amazon Resource Name (ARN) of the RAM Resource Share.
 */
public data class ResourceAssociationArgs(
    public val resourceArn: Output<String>? = null,
    public val resourceShareArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ram.ResourceAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ram.ResourceAssociationArgs =
        com.pulumi.aws.ram.ResourceAssociationArgs.builder()
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .resourceShareArn(resourceShareArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceAssociationArgs].
 */
@PulumiTagMarker
public class ResourceAssociationArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var resourceShareArn: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
     */
    @JvmName("ihxdbcmmadmwpicx")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the RAM Resource Share.
     */
    @JvmName("nlyjbaldhtqaopmp")
    public suspend fun resourceShareArn(`value`: Output<String>) {
        this.resourceShareArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
     */
    @JvmName("lttwqoggwjmkbxix")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the RAM Resource Share.
     */
    @JvmName("qbmkdqaykugayqqu")
    public suspend fun resourceShareArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceShareArn = mapped
    }

    internal fun build(): ResourceAssociationArgs = ResourceAssociationArgs(
        resourceArn = resourceArn,
        resourceShareArn = resourceShareArn,
    )
}
