@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.aws.ram.ResourceShareAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manage accepting a Resource Access Manager (RAM) Resource Share invitation. From a _receiver_ AWS account, accept an invitation to share resources that were shared by a _sender_ AWS account. To create a resource share in the _sender_, see the `aws.ram.ResourceShare` resource.
 * > **Note:** If both AWS accounts are in the same Organization and [RAM Sharing with AWS Organizations is enabled](https://docs.aws.amazon.com/ram/latest/userguide/getting-started-sharing.html#getting-started-sharing-orgs), this resource is not necessary as RAM Resource Share invitations are not used.
 * ## Example Usage
 * This configuration provides an example of using multiple AWS providers to configure two different AWS accounts. In the _sender_ account, the configuration creates a `aws.ram.ResourceShare` and uses a data source in the _receiver_ account to create a `aws.ram.PrincipalAssociation` resource with the _receiver's_ account ID. In the _receiver_ account, the configuration accepts the invitation to share resources with the `aws.ram.ResourceShareAccepter`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.ram.ResourceShare;
 * import com.pulumi.aws.ram.ResourceShareArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ram.PrincipalAssociation;
 * import com.pulumi.aws.ram.PrincipalAssociationArgs;
 * import com.pulumi.aws.ram.ResourceShareAccepter;
 * import com.pulumi.aws.ram.ResourceShareAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alternate = new Provider("alternate", ProviderArgs.builder()
 *             .profile("profile1")
 *             .build());
 *         var senderShare = new ResourceShare("senderShare", ResourceShareArgs.builder()
 *             .allowExternalPrincipals(true)
 *             .tags(Map.of("Name", "tf-test-resource-share"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         final var receiver = AwsFunctions.getCallerIdentity();
 *         var senderInvite = new PrincipalAssociation("senderInvite", PrincipalAssociationArgs.builder()
 *             .principal(receiver.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .resourceShareArn(senderShare.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var receiverAccept = new ResourceShareAccepter("receiverAccept", ResourceShareAccepterArgs.builder()
 *             .shareArn(senderInvite.resourceShareArn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import resource share accepters using the resource share ARN. For example:
 * ```sh
 *  $ pulumi import aws:ram/resourceShareAccepter:ResourceShareAccepter example arn:aws:ram:us-east-1:123456789012:resource-share/c4b56393-e8d9-89d9-6dc9-883752de4767
 * ```
 * @property shareArn The ARN of the resource share.
 */
public data class ResourceShareAccepterArgs(
    public val shareArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ram.ResourceShareAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ram.ResourceShareAccepterArgs =
        com.pulumi.aws.ram.ResourceShareAccepterArgs.builder()
            .shareArn(shareArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceShareAccepterArgs].
 */
@PulumiTagMarker
public class ResourceShareAccepterArgsBuilder internal constructor() {
    private var shareArn: Output<String>? = null

    /**
     * @param value The ARN of the resource share.
     */
    @JvmName("fyqcrwkngqrqyhba")
    public suspend fun shareArn(`value`: Output<String>) {
        this.shareArn = value
    }

    /**
     * @param value The ARN of the resource share.
     */
    @JvmName("qnquutnqqkuuxomi")
    public suspend fun shareArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareArn = mapped
    }

    internal fun build(): ResourceShareAccepterArgs = ResourceShareAccepterArgs(
        shareArn = shareArn,
    )
}
