@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SharingWithOrganization].
 */
@PulumiTagMarker
public class SharingWithOrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SharingWithOrganizationArgs = SharingWithOrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SharingWithOrganizationArgsBuilder.() -> Unit) {
        val builder = SharingWithOrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SharingWithOrganization {
        val builtJavaResource = com.pulumi.aws.ram.SharingWithOrganization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SharingWithOrganization(builtJavaResource)
    }
}

/**
 * Manages Resource Access Manager (RAM) Resource Sharing with AWS Organizations. If you enable sharing with your organization, you can share resources without using invitations. Refer to the [AWS RAM user guide](https://docs.aws.amazon.com/ram/latest/userguide/getting-started-sharing.html#getting-started-sharing-orgs) for more details.
 * > **NOTE:** Use this resource to manage resource sharing within your organization, **not** the `aws.organizations.Organization` resource with `ram.amazonaws.com` configured in `aws_service_access_principals`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.SharingWithOrganization;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SharingWithOrganization("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the resource using the current AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:ram/sharingWithOrganization:SharingWithOrganization example 123456789012
 * ```
 *
 */
public class SharingWithOrganization internal constructor(
    override val javaResource: com.pulumi.aws.ram.SharingWithOrganization,
) : KotlinCustomResource(javaResource, SharingWithOrganizationMapper)

public object SharingWithOrganizationMapper : ResourceMapper<SharingWithOrganization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ram.SharingWithOrganization::class == javaResource::class

    override fun map(javaResource: Resource): SharingWithOrganization =
        SharingWithOrganization(javaResource as com.pulumi.aws.ram.SharingWithOrganization)
}

/**
 * @see [SharingWithOrganization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SharingWithOrganization].
 */
public suspend fun sharingWithOrganization(
    name: String,
    block: suspend SharingWithOrganizationResourceBuilder.() -> Unit,
): SharingWithOrganization {
    val builder = SharingWithOrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SharingWithOrganization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sharingWithOrganization(name: String): SharingWithOrganization {
    val builder = SharingWithOrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
