@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.aws.ram.SharingWithOrganizationArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress

/**
 * Manages Resource Access Manager (RAM) Resource Sharing with AWS Organizations. If you enable sharing with your organization, you can share resources without using invitations. Refer to the [AWS RAM user guide](https://docs.aws.amazon.com/ram/latest/userguide/getting-started-sharing.html#getting-started-sharing-orgs) for more details.
 * > **NOTE:** Use this resource to manage resource sharing within your organization, **not** the `aws.organizations.Organization` resource with `ram.amazonaws.com` configured in `aws_service_access_principals`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.SharingWithOrganization;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SharingWithOrganization("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the resource using the current AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:ram/sharingWithOrganization:SharingWithOrganization example 123456789012
 * ```
 */
public class SharingWithOrganizationArgs() :
    ConvertibleToJava<com.pulumi.aws.ram.SharingWithOrganizationArgs> {
    override fun toJava(): com.pulumi.aws.ram.SharingWithOrganizationArgs =
        com.pulumi.aws.ram.SharingWithOrganizationArgs.builder().build()
}

/**
 * Builder for [SharingWithOrganizationArgs].
 */
@PulumiTagMarker
public class SharingWithOrganizationArgsBuilder internal constructor() {
    internal fun build(): SharingWithOrganizationArgs = SharingWithOrganizationArgs()
}
