@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin.inputs

import com.pulumi.aws.ram.inputs.GetResourceShareFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the tag key to filter on.
 * @property values Value of the tag key.
 */
public data class GetResourceShareFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ram.inputs.GetResourceShareFilter> {
    override fun toJava(): com.pulumi.aws.ram.inputs.GetResourceShareFilter =
        com.pulumi.aws.ram.inputs.GetResourceShareFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetResourceShareFilter].
 */
@PulumiTagMarker
public class GetResourceShareFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the tag key to filter on.
     */
    @JvmName("utklqoaqbfehpijf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Value of the tag key.
     */
    @JvmName("ypwldaapbpbbnpdh")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Value of the tag key.
     */
    @JvmName("ydbkilwlenjwmytb")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetResourceShareFilter = GetResourceShareFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
