@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getResourceShare.
 * @property arn ARN of the resource share.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property owningAccountId ID of the AWS account that owns the resource share.
 * @property resourceArns A list of resource ARNs associated with the resource share.
 * @property resourceOwner
 * @property resourceShareStatus
 * @property status Status of the resource share.
 * @property tags Tags attached to the resource share.
 */
public data class GetResourceShareResult(
    public val arn: String,
    public val filters: List<GetResourceShareFilter>? = null,
    public val id: String,
    public val name: String,
    public val owningAccountId: String,
    public val resourceArns: List<String>,
    public val resourceOwner: String,
    public val resourceShareStatus: String? = null,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ram.outputs.GetResourceShareResult):
            GetResourceShareResult = GetResourceShareResult(
            arn = javaType.arn(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ram.kotlin.outputs.GetResourceShareFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            owningAccountId = javaType.owningAccountId(),
            resourceArns = javaType.resourceArns().map({ args0 -> args0 }),
            resourceOwner = javaType.resourceOwner(),
            resourceShareStatus = javaType.resourceShareStatus().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
