@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin

import com.pulumi.aws.rbin.kotlin.outputs.RuleLockConfiguration
import com.pulumi.aws.rbin.kotlin.outputs.RuleResourceTag
import com.pulumi.aws.rbin.kotlin.outputs.RuleRetentionPeriod
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.rbin.kotlin.outputs.RuleLockConfiguration.Companion.toKotlin as ruleLockConfigurationToKotlin
import com.pulumi.aws.rbin.kotlin.outputs.RuleResourceTag.Companion.toKotlin as ruleResourceTagToKotlin
import com.pulumi.aws.rbin.kotlin.outputs.RuleRetentionPeriod.Companion.toKotlin as ruleRetentionPeriodToKotlin

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.aws.rbin.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS RBin Rule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rbin.Rule;
 * import com.pulumi.aws.rbin.RuleArgs;
 * import com.pulumi.aws.rbin.inputs.RuleResourceTagArgs;
 * import com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .description("example_rule")
 *             .resourceTags(RuleResourceTagArgs.builder()
 *                 .resourceTagKey("tag_key")
 *                 .resourceTagValue("tag_value")
 *                 .build())
 *             .resourceType("EBS_SNAPSHOT")
 *             .retentionPeriod(RuleRetentionPeriodArgs.builder()
 *                 .retentionPeriodUnit("DAYS")
 *                 .retentionPeriodValue(10)
 *                 .build())
 *             .tags(Map.of("test_tag_key", "test_tag_value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RBin Rule using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:rbin/rule:Rule example examplerule
 * ```
 *
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.aws.rbin.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The retention rule description.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Information about the retention rule lock configuration. See `lock_configuration` below.
     */
    public val lockConfiguration: Output<RuleLockConfiguration>?
        get() = javaResource.lockConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ruleLockConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * (Timestamp) The date and time at which the unlock delay is set to expire. Only returned for retention rules that have been unlocked and that are still within the unlock delay period.
     */
    public val lockEndTime: Output<String>
        get() = javaResource.lockEndTime().applyValue({ args0 -> args0 })

    /**
     * (Optional) The lock state of the retention rules to list. Only retention rules with the specified lock state are returned. Valid values are `locked`, `pending_unlock`, `unlocked`.
     */
    public val lockState: Output<String>
        get() = javaResource.lockState().applyValue({ args0 -> args0 })

    /**
     * Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    public val resourceTags: Output<List<RuleResourceTag>>
        get() = javaResource.resourceTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ruleResourceTagToKotlin(args0)
                })
            })
        })

    /**
     * The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * The following arguments are optional:
     */
    public val retentionPeriod: Output<RuleRetentionPeriod>
        get() = javaResource.retentionPeriod().applyValue({ args0 ->
            args0.let({ args0 ->
                ruleRetentionPeriodToKotlin(args0)
            })
        })

    /**
     * (String) The state of the retention rule. Only retention rules that are in the `available` state retain resources. Valid values include `pending` and `available`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rbin.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(javaResource as com.pulumi.aws.rbin.Rule)
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
