@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin

import com.pulumi.aws.rbin.RuleArgs.builder
import com.pulumi.aws.rbin.kotlin.inputs.RuleLockConfigurationArgs
import com.pulumi.aws.rbin.kotlin.inputs.RuleLockConfigurationArgsBuilder
import com.pulumi.aws.rbin.kotlin.inputs.RuleResourceTagArgs
import com.pulumi.aws.rbin.kotlin.inputs.RuleResourceTagArgsBuilder
import com.pulumi.aws.rbin.kotlin.inputs.RuleRetentionPeriodArgs
import com.pulumi.aws.rbin.kotlin.inputs.RuleRetentionPeriodArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS RBin Rule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rbin.Rule;
 * import com.pulumi.aws.rbin.RuleArgs;
 * import com.pulumi.aws.rbin.inputs.RuleResourceTagArgs;
 * import com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .description("example_rule")
 *             .resourceTags(RuleResourceTagArgs.builder()
 *                 .resourceTagKey("tag_key")
 *                 .resourceTagValue("tag_value")
 *                 .build())
 *             .resourceType("EBS_SNAPSHOT")
 *             .retentionPeriod(RuleRetentionPeriodArgs.builder()
 *                 .retentionPeriodUnit("DAYS")
 *                 .retentionPeriodValue(10)
 *                 .build())
 *             .tags(Map.of("test_tag_key", "test_tag_value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RBin Rule using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:rbin/rule:Rule example examplerule
 * ```
 * @property description The retention rule description.
 * @property lockConfiguration Information about the retention rule lock configuration. See `lock_configuration` below.
 * @property resourceTags Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
 * @property resourceType The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
 * @property retentionPeriod Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
 * The following arguments are optional:
 * @property tags
 */
public data class RuleArgs(
    public val description: Output<String>? = null,
    public val lockConfiguration: Output<RuleLockConfigurationArgs>? = null,
    public val resourceTags: Output<List<RuleResourceTagArgs>>? = null,
    public val resourceType: Output<String>? = null,
    public val retentionPeriod: Output<RuleRetentionPeriodArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rbin.RuleArgs> {
    override fun toJava(): com.pulumi.aws.rbin.RuleArgs = com.pulumi.aws.rbin.RuleArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .lockConfiguration(lockConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .resourceTags(
            resourceTags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .resourceType(resourceType?.applyValue({ args0 -> args0 }))
        .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var lockConfiguration: Output<RuleLockConfigurationArgs>? = null

    private var resourceTags: Output<List<RuleResourceTagArgs>>? = null

    private var resourceType: Output<String>? = null

    private var retentionPeriod: Output<RuleRetentionPeriodArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The retention rule description.
     */
    @JvmName("wolujtfygrctxxir")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the retention rule lock configuration. See `lock_configuration` below.
     */
    @JvmName("gvsrpliporwoayii")
    public suspend fun lockConfiguration(`value`: Output<RuleLockConfigurationArgs>) {
        this.lockConfiguration = value
    }

    /**
     * @param value Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("lpymribjiuvvgasx")
    public suspend fun resourceTags(`value`: Output<List<RuleResourceTagArgs>>) {
        this.resourceTags = value
    }

    @JvmName("vrvdxhvltdmdioeo")
    public suspend fun resourceTags(vararg values: Output<RuleResourceTagArgs>) {
        this.resourceTags = Output.all(values.asList())
    }

    /**
     * @param values Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("yclvrkwcruyxiyif")
    public suspend fun resourceTags(values: List<Output<RuleResourceTagArgs>>) {
        this.resourceTags = Output.all(values)
    }

    /**
     * @param value The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
     */
    @JvmName("ewxywctmobslkuak")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * The following arguments are optional:
     */
    @JvmName("bwfaecnvaqoqsyty")
    public suspend fun retentionPeriod(`value`: Output<RuleRetentionPeriodArgs>) {
        this.retentionPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("qjanxecfpdllxnlg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The retention rule description.
     */
    @JvmName("ivhcpmlhimkpjrwp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the retention rule lock configuration. See `lock_configuration` below.
     */
    @JvmName("gorsqfnpdsbssirt")
    public suspend fun lockConfiguration(`value`: RuleLockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockConfiguration = mapped
    }

    /**
     * @param argument Information about the retention rule lock configuration. See `lock_configuration` below.
     */
    @JvmName("jlamaloqchkhyrrh")
    public suspend
    fun lockConfiguration(argument: suspend RuleLockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RuleLockConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lockConfiguration = mapped
    }

    /**
     * @param value Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("etotlmufnxjnfevu")
    public suspend fun resourceTags(`value`: List<RuleResourceTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param argument Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("envnckbdqbaaiosr")
    public suspend fun resourceTags(argument: List<suspend RuleResourceTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleResourceTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("xnrmmvsnirfsqcbo")
    public suspend fun resourceTags(vararg argument: suspend RuleResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleResourceTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("tmlxrlmaboyiwnua")
    public suspend fun resourceTags(argument: suspend RuleResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleResourceTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param values Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     */
    @JvmName("yexaywcphukfxqok")
    public suspend fun resourceTags(vararg values: RuleResourceTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
     */
    @JvmName("iyebwibxkjktgmru")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * The following arguments are optional:
     */
    @JvmName("cvgntivsjqewirvt")
    public suspend fun retentionPeriod(`value`: RuleRetentionPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param argument Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * The following arguments are optional:
     */
    @JvmName("hfuecqaxjbhnnewn")
    public suspend fun retentionPeriod(argument: suspend RuleRetentionPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRetentionPeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("chxpnmnkqrtvrunn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hvvbawpbikmsdqty")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        description = description,
        lockConfiguration = lockConfiguration,
        resourceTags = resourceTags,
        resourceType = resourceType,
        retentionPeriod = retentionPeriod,
        tags = tags,
    )
}
