@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.inputs

import com.pulumi.aws.rbin.inputs.RuleLockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property unlockDelay Information about the retention rule unlock delay. See `unlock_delay` below.
 */
public data class RuleLockConfigurationArgs(
    public val unlockDelay: Output<RuleLockConfigurationUnlockDelayArgs>,
) : ConvertibleToJava<com.pulumi.aws.rbin.inputs.RuleLockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.rbin.inputs.RuleLockConfigurationArgs =
        com.pulumi.aws.rbin.inputs.RuleLockConfigurationArgs.builder()
            .unlockDelay(unlockDelay.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleLockConfigurationArgs].
 */
@PulumiTagMarker
public class RuleLockConfigurationArgsBuilder internal constructor() {
    private var unlockDelay: Output<RuleLockConfigurationUnlockDelayArgs>? = null

    /**
     * @param value Information about the retention rule unlock delay. See `unlock_delay` below.
     */
    @JvmName("xuxxodiqbwcepowd")
    public suspend fun unlockDelay(`value`: Output<RuleLockConfigurationUnlockDelayArgs>) {
        this.unlockDelay = value
    }

    /**
     * @param value Information about the retention rule unlock delay. See `unlock_delay` below.
     */
    @JvmName("powrujhennnxtyer")
    public suspend fun unlockDelay(`value`: RuleLockConfigurationUnlockDelayArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unlockDelay = mapped
    }

    /**
     * @param argument Information about the retention rule unlock delay. See `unlock_delay` below.
     */
    @JvmName("sodragbdqawtbjgj")
    public suspend
    fun unlockDelay(argument: suspend RuleLockConfigurationUnlockDelayArgsBuilder.() -> Unit) {
        val toBeMapped = RuleLockConfigurationUnlockDelayArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.unlockDelay = mapped
    }

    internal fun build(): RuleLockConfigurationArgs = RuleLockConfigurationArgs(
        unlockDelay = unlockDelay ?: throw PulumiNullFieldException("unlockDelay"),
    )
}
