@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.inputs

import com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property retentionPeriodUnit The unit of time in which the retention period is measured. Currently, only DAYS is supported.
 * @property retentionPeriodValue The period value for which the retention rule is to retain resources. The period is measured using the unit specified for RetentionPeriodUnit.
 */
public data class RuleRetentionPeriodArgs(
    public val retentionPeriodUnit: Output<String>,
    public val retentionPeriodValue: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs> {
    override fun toJava(): com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs =
        com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs.builder()
            .retentionPeriodUnit(retentionPeriodUnit.applyValue({ args0 -> args0 }))
            .retentionPeriodValue(retentionPeriodValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRetentionPeriodArgs].
 */
@PulumiTagMarker
public class RuleRetentionPeriodArgsBuilder internal constructor() {
    private var retentionPeriodUnit: Output<String>? = null

    private var retentionPeriodValue: Output<Int>? = null

    /**
     * @param value The unit of time in which the retention period is measured. Currently, only DAYS is supported.
     */
    @JvmName("suityuekqwyygjvd")
    public suspend fun retentionPeriodUnit(`value`: Output<String>) {
        this.retentionPeriodUnit = value
    }

    /**
     * @param value The period value for which the retention rule is to retain resources. The period is measured using the unit specified for RetentionPeriodUnit.
     */
    @JvmName("awpvrjkgubqtwjyq")
    public suspend fun retentionPeriodValue(`value`: Output<Int>) {
        this.retentionPeriodValue = value
    }

    /**
     * @param value The unit of time in which the retention period is measured. Currently, only DAYS is supported.
     */
    @JvmName("oboqobiqumcywawr")
    public suspend fun retentionPeriodUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPeriodUnit = mapped
    }

    /**
     * @param value The period value for which the retention rule is to retain resources. The period is measured using the unit specified for RetentionPeriodUnit.
     */
    @JvmName("scxbmvnyggtashkj")
    public suspend fun retentionPeriodValue(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPeriodValue = mapped
    }

    internal fun build(): RuleRetentionPeriodArgs = RuleRetentionPeriodArgs(
        retentionPeriodUnit = retentionPeriodUnit ?: throw PulumiNullFieldException("retentionPeriodUnit"),
        retentionPeriodValue = retentionPeriodValue ?: throw
            PulumiNullFieldException("retentionPeriodValue"),
    )
}
