@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property unlockDelayUnit The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
 * @property unlockDelayValue The unlock delay period, measured in the unit specified for UnlockDelayUnit.
 */
public data class RuleLockConfigurationUnlockDelay(
    public val unlockDelayUnit: String,
    public val unlockDelayValue: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rbin.outputs.RuleLockConfigurationUnlockDelay):
            RuleLockConfigurationUnlockDelay = RuleLockConfigurationUnlockDelay(
            unlockDelayUnit = javaType.unlockDelayUnit(),
            unlockDelayValue = javaType.unlockDelayValue(),
        )
    }
}
