@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceTagKey The tag key.
 * The following argument is optional:
 * @property resourceTagValue The tag value.
 */
public data class RuleResourceTag(
    public val resourceTagKey: String,
    public val resourceTagValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rbin.outputs.RuleResourceTag): RuleResourceTag =
            RuleResourceTag(
                resourceTagKey = javaType.resourceTagKey(),
                resourceTagValue = javaType.resourceTagValue().map({ args0 -> args0 }).orElse(null),
            )
    }
}
