@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property retentionPeriodUnit The unit of time in which the retention period is measured. Currently, only DAYS is supported.
 * @property retentionPeriodValue The period value for which the retention rule is to retain resources. The period is measured using the unit specified for RetentionPeriodUnit.
 */
public data class RuleRetentionPeriod(
    public val retentionPeriodUnit: String,
    public val retentionPeriodValue: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rbin.outputs.RuleRetentionPeriod):
            RuleRetentionPeriod = RuleRetentionPeriod(
            retentionPeriodUnit = javaType.retentionPeriodUnit(),
            retentionPeriodValue = javaType.retentionPeriodValue(),
        )
    }
}
