@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterActivityStream].
 */
@PulumiTagMarker
public class ClusterActivityStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterActivityStreamArgs = ClusterActivityStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterActivityStreamArgsBuilder.() -> Unit) {
        val builder = ClusterActivityStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterActivityStream {
        val builtJavaResource = com.pulumi.aws.rds.ClusterActivityStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterActivityStream(builtJavaResource)
    }
}

/**
 * Manages RDS Aurora Cluster Database Activity Streams.
 * Database Activity Streams have some limits and requirements, refer to the [Monitoring Amazon Aurora using Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) documentation for detailed limitations and requirements.
 * > **Note:** This resource always calls the RDS [`StartActivityStream`][2] API with the `ApplyImmediately` parameter set to `true`. This is because the provider needs the activity stream to be started in order for it to get the associated attributes.
 * > **Note:** This resource depends on having at least one `aws.rds.ClusterInstance` created. To avoid race conditions when all resources are being created together, add an explicit resource reference using the resource `depends_on` meta-argument.
 * > **Note:** This resource is available in all regions except the following: `cn-north-1`, `cn-northwest-1`, `us-gov-east-1`, `us-gov-west-1`
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.ClusterActivityStream;
 * import com.pulumi.aws.rds.ClusterActivityStreamArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .engine("aurora-postgresql")
 *             .engineVersion("13.4")
 *             .build());
 *         var defaultClusterInstance = new ClusterInstance("defaultClusterInstance", ClusterInstanceArgs.builder()
 *             .identifier("aurora-instance-demo")
 *             .clusterIdentifier(defaultCluster.clusterIdentifier())
 *             .engine(defaultCluster.engine())
 *             .instanceClass("db.r6g.large")
 *             .build());
 *         var defaultKey = new Key("defaultKey", KeyArgs.builder()
 *             .description("AWS KMS Key to encrypt Database Activity Stream")
 *             .build());
 *         var defaultClusterActivityStream = new ClusterActivityStream("defaultClusterActivityStream", ClusterActivityStreamArgs.builder()
 *             .resourceArn(defaultCluster.arn())
 *             .mode("async")
 *             .kmsKeyId(defaultKey.keyId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultClusterInstance)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS Aurora Cluster Database Activity Streams using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:rds/clusterActivityStream:ClusterActivityStream default arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster-demo
 * ```
 *
 */
public class ClusterActivityStream internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterActivityStream,
) : KotlinCustomResource(javaResource, ClusterActivityStreamMapper) {
    /**
     * Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults `false`.
     */
    public val engineNativeAuditFieldsIncluded: Output<Boolean>?
        get() = javaResource.engineNativeAuditFieldsIncluded().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Amazon Kinesis data stream to be used for the database activity stream.
     */
    public val kinesisStreamName: Output<String>
        get() = javaResource.kinesisStreamName().applyValue({ args0 -> args0 })

    /**
     * The AWS KMS key identifier for encrypting messages in the database activity stream. The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. One of: `sync`, `async`.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the DB cluster.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object ClusterActivityStreamMapper : ResourceMapper<ClusterActivityStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterActivityStream::class == javaResource::class

    override fun map(javaResource: Resource): ClusterActivityStream =
        ClusterActivityStream(javaResource as com.pulumi.aws.rds.ClusterActivityStream)
}

/**
 * @see [ClusterActivityStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterActivityStream].
 */
public suspend fun clusterActivityStream(
    name: String,
    block: suspend ClusterActivityStreamResourceBuilder.() -> Unit,
): ClusterActivityStream {
    val builder = ClusterActivityStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterActivityStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterActivityStream(name: String): ClusterActivityStream {
    val builder = ClusterActivityStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
