@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ClusterActivityStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages RDS Aurora Cluster Database Activity Streams.
 * Database Activity Streams have some limits and requirements, refer to the [Monitoring Amazon Aurora using Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) documentation for detailed limitations and requirements.
 * > **Note:** This resource always calls the RDS [`StartActivityStream`][2] API with the `ApplyImmediately` parameter set to `true`. This is because the provider needs the activity stream to be started in order for it to get the associated attributes.
 * > **Note:** This resource depends on having at least one `aws.rds.ClusterInstance` created. To avoid race conditions when all resources are being created together, add an explicit resource reference using the resource `depends_on` meta-argument.
 * > **Note:** This resource is available in all regions except the following: `cn-north-1`, `cn-northwest-1`, `us-gov-east-1`, `us-gov-west-1`
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.ClusterActivityStream;
 * import com.pulumi.aws.rds.ClusterActivityStreamArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .engine("aurora-postgresql")
 *             .engineVersion("13.4")
 *             .build());
 *         var defaultClusterInstance = new ClusterInstance("defaultClusterInstance", ClusterInstanceArgs.builder()
 *             .identifier("aurora-instance-demo")
 *             .clusterIdentifier(defaultCluster.clusterIdentifier())
 *             .engine(defaultCluster.engine())
 *             .instanceClass("db.r6g.large")
 *             .build());
 *         var defaultKey = new Key("defaultKey", KeyArgs.builder()
 *             .description("AWS KMS Key to encrypt Database Activity Stream")
 *             .build());
 *         var defaultClusterActivityStream = new ClusterActivityStream("defaultClusterActivityStream", ClusterActivityStreamArgs.builder()
 *             .resourceArn(defaultCluster.arn())
 *             .mode("async")
 *             .kmsKeyId(defaultKey.keyId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultClusterInstance)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS Aurora Cluster Database Activity Streams using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:rds/clusterActivityStream:ClusterActivityStream default arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster-demo
 * ```
 * @property engineNativeAuditFieldsIncluded Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults `false`.
 * @property kmsKeyId The AWS KMS key identifier for encrypting messages in the database activity stream. The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
 * @property mode Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. One of: `sync`, `async`.
 * @property resourceArn The Amazon Resource Name (ARN) of the DB cluster.
 */
public data class ClusterActivityStreamArgs(
    public val engineNativeAuditFieldsIncluded: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ClusterActivityStreamArgs> {
    override fun toJava(): com.pulumi.aws.rds.ClusterActivityStreamArgs =
        com.pulumi.aws.rds.ClusterActivityStreamArgs.builder()
            .engineNativeAuditFieldsIncluded(engineNativeAuditFieldsIncluded?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterActivityStreamArgs].
 */
@PulumiTagMarker
public class ClusterActivityStreamArgsBuilder internal constructor() {
    private var engineNativeAuditFieldsIncluded: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var mode: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults `false`.
     */
    @JvmName("sirobuyjluwaeleq")
    public suspend fun engineNativeAuditFieldsIncluded(`value`: Output<Boolean>) {
        this.engineNativeAuditFieldsIncluded = value
    }

    /**
     * @param value The AWS KMS key identifier for encrypting messages in the database activity stream. The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    @JvmName("ayslndnmxfqcvuli")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. One of: `sync`, `async`.
     */
    @JvmName("lkhnwmwirbjxkuva")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the DB cluster.
     */
    @JvmName("kkkxnsjvcbqvustr")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults `false`.
     */
    @JvmName("djlwwqpfpgrjdaha")
    public suspend fun engineNativeAuditFieldsIncluded(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineNativeAuditFieldsIncluded = mapped
    }

    /**
     * @param value The AWS KMS key identifier for encrypting messages in the database activity stream. The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    @JvmName("oqvvtywelkarvqqn")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. One of: `sync`, `async`.
     */
    @JvmName("cgipxlpclgnrpnna")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the DB cluster.
     */
    @JvmName("oyivjxmjaastddgb")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ClusterActivityStreamArgs = ClusterActivityStreamArgs(
        engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded,
        kmsKeyId = kmsKeyId,
        mode = mode,
        resourceArn = resourceArn,
    )
}
