@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterEndpoint].
 */
@PulumiTagMarker
public class ClusterEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterEndpointArgs = ClusterEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterEndpointArgsBuilder.() -> Unit) {
        val builder = ClusterEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterEndpoint {
        val builtJavaResource = com.pulumi.aws.rds.ClusterEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterEndpoint(builtJavaResource)
    }
}

/**
 * Manages an RDS Aurora Cluster Endpoint.
 * You can refer to the [User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html#Aurora.Endpoints.Cluster).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.aws.rds.ClusterEndpoint;
 * import com.pulumi.aws.rds.ClusterEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("bar")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .build());
 *         var test1 = new ClusterInstance("test1", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test1")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var test2 = new ClusterInstance("test2", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test2")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var test3 = new ClusterInstance("test3", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test3")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var eligible = new ClusterEndpoint("eligible", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(default_.id())
 *             .clusterEndpointIdentifier("reader")
 *             .customEndpointType("READER")
 *             .excludedMembers(
 *                 test1.id(),
 *                 test2.id())
 *             .build());
 *         var static_ = new ClusterEndpoint("static", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(default_.id())
 *             .clusterEndpointIdentifier("static")
 *             .customEndpointType("READER")
 *             .staticMembers(
 *                 test1.id(),
 *                 test3.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS Clusters Endpoint using the `cluster_endpoint_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/clusterEndpoint:ClusterEndpoint custom_reader aurora-prod-cluster-custom-reader
 * ```
 *
 */
public class ClusterEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterEndpoint,
) : KotlinCustomResource(javaResource, ClusterEndpointMapper) {
    /**
     * Amazon Resource Name (ARN) of cluster
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     */
    public val clusterEndpointIdentifier: Output<String>
        get() = javaResource.clusterEndpointIdentifier().applyValue({ args0 -> args0 })

    /**
     * The cluster identifier.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The type of the endpoint. One of: READER , ANY .
     */
    public val customEndpointType: Output<String>
        get() = javaResource.customEndpointType().applyValue({ args0 -> args0 })

    /**
     * A custom endpoint for the Aurora cluster
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
     */
    public val excludedMembers: Output<List<String>>?
        get() = javaResource.excludedMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
     */
    public val staticMembers: Output<List<String>>?
        get() = javaResource.staticMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterEndpointMapper : ResourceMapper<ClusterEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ClusterEndpoint = ClusterEndpoint(
        javaResource as
            com.pulumi.aws.rds.ClusterEndpoint,
    )
}

/**
 * @see [ClusterEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterEndpoint].
 */
public suspend fun clusterEndpoint(
    name: String,
    block: suspend ClusterEndpointResourceBuilder.() -> Unit,
): ClusterEndpoint {
    val builder = ClusterEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterEndpoint(name: String): ClusterEndpoint {
    val builder = ClusterEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
